/***************************************************************************
    copyright            : (C) 2005 by Umesh Shankar
    email                : ushankar@cs.berkeley.edu
 ***************************************************************************/

/***************************************************************************
 *   This library is free software; you can redistribute it and/or modify  *
 *   it  under the terms of the GNU Lesser General Public License version  *
 *   2.1 as published by the Free Software Foundation.                     *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  *
 *   USA                                                                   *
 ***************************************************************************/

#include "wmatag.h"
#include <tdebug.h>
#include <tfile.h>
#include <audioproperties.h>

namespace TagLib {
////////////////////////////////////////////////////////////////////////////////
// public members
////////////////////////////////////////////////////////////////////////////////

WMA::File::File(const char *file, bool readProperties,
                 Properties::ReadStyle propertiesStyle) : TagLib::File(file)
{
  wmaTag = NULL;
  if(isOpen()) {
    wmaTag = new WMATag();
    read(readProperties, propertiesStyle);
  }
}

WMA::File::~File()
{ 
  delete wmaTag; 
}

TagLib::Tag *WMA::File::tag() const
{
  return wmaTag;
}

TagLib::WMA::WMATag *WMA::File::getWMATag() const
{
  return wmaTag;
}

WMA::Properties *WMA::File::audioProperties() const
{
  return properties;
}

bool WMA::File::save()
{
  debug ("WMA::File: Saving not supported yet.");
  return false;
}


////////////////////////////////////////////////////////////////////////////////
// private members
////////////////////////////////////////////////////////////////////////////////

void WMA::File::read(bool readProperties, Properties::ReadStyle propertiesStyle)
{
  if(readProperties)
    properties = new Properties(propertiesStyle);

  bool success = asfReadHeader();
}
}
